/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.minecraft.class_161;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RegistrateAdvancementProvider
implements RegistrateProvider,
Consumer<class_161> {
    private static final Logger log = LogManager.getLogger(RegistrateAdvancementProvider.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final AbstractRegistrate<?> owner;
    private final class_7784 packOutput;
    private final CompletableFuture<class_7225.class_7874> registriesLookup;
    private final List<CompletableFuture<?>> advancementsToSave = Lists.newArrayList();
    @Nullable
    private class_7403 cache;
    private Set<class_2960> seenAdvancements = new HashSet<class_2960>();

    public RegistrateAdvancementProvider(AbstractRegistrate<?> owner, class_7784 packOutputIn, CompletableFuture<class_7225.class_7874> registriesLookupIn) {
        this.owner = owner;
        this.packOutput = packOutputIn;
        this.registriesLookup = registriesLookupIn;
    }

    @Override
    public EnvType getSide() {
        return EnvType.SERVER;
    }

    public class_5250 title(String category, String name, String title) {
        return this.owner.addLang("advancements", new class_2960(category, name), "title", title);
    }

    public class_5250 desc(String category, String name, String desc) {
        return this.owner.addLang("advancements", new class_2960(category, name), "description", desc);
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        return this.registriesLookup.thenCompose(lookup -> {
            this.advancementsToSave.clear();
            try {
                this.cache = cache;
                this.seenAdvancements.clear();
                this.owner.genData(ProviderType.ADVANCEMENT, this);
            }
            finally {
                this.cache = null;
            }
            return CompletableFuture.allOf((CompletableFuture[])this.advancementsToSave.toArray(CompletableFuture[]::new));
        });
    }

    @Override
    public void accept(@Nullable class_161 t) {
        class_7403 cache = this.cache;
        if (cache == null) {
            throw new IllegalStateException("Cannot accept advancements outside of act");
        }
        Objects.requireNonNull(t, "Cannot accept a null advancement");
        Path path = this.packOutput.method_45971();
        if (!this.seenAdvancements.add(t.method_688())) {
            throw new IllegalStateException("Duplicate advancement " + t.method_688());
        }
        Path path1 = RegistrateAdvancementProvider.getPath(path, t);
        this.advancementsToSave.add(class_2405.method_10320((class_7403)cache, (JsonElement)t.method_689().method_698(), (Path)path1));
    }

    private static Path getPath(Path pathIn, class_161 advancementIn) {
        return pathIn.resolve("data/" + advancementIn.method_688().method_12836() + "/advancements/" + advancementIn.method_688().method_12832() + ".json");
    }

    public String method_10321() {
        return "Advancements";
    }
}

